<?php

// Hook to 'admin_menu' action to register the admin menu
add_action('admin_menu', 'caravan_builder_super_admin_menu');

function caravan_builder_super_admin_menu() {
    // This function adds a new top-level menu to the admin panel.
    add_menu_page(
        'Caravan Builder',
        'Caravan Builder Super Admin Settings',
        'manage_options',
        'caravan-builder-super-admin-settings',
        'caravan_builder_menu_page',
        'dashicons-admin-generic',
        6
    );
}

// Callback function to display the content of the custom menu page
function caravan_builder_menu_page() {
    global $caravanBuilder;
    ?>
    <div class="wrap">
        <h1><?php esc_html_e('Caravan Builder', 'textdomain'); ?></h1>
        <p><?php esc_html_e('Welcome to the caravan builder admin menu page!', 'textdomain'); ?></p>
        <p>
            <?php

                    ?>
                    <div id="root" class="wrap"></div>
                    <script>
                        // This script snippet can be used to inline any necessary variables or state
                        // from PHP into your React app if needed
                    </script>
                    <?php
            ?>
        </p>
    </div>
    <?php
}